<?php

namespace Auth0\SDK\Exception;

/**
 * Represents all errors generated by SDK itself.
 */
class EmptyOrInvalidParameterException extends CoreException
{

    /**
     * EmptyOrInvalidParameterException constructor.
     *
     * @param string $parameter_name The parameter name that is missing or invalid.
     */
    public function __construct($parameter_name)
    {
        parent::__construct('Empty or invalid '.$parameter_name.'.');
    }
}
